/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.util.I2PThread;
import net.i2p.util.NativeBigInteger;

class YKGenerator {
    private final int MIN_NUM_BUILDERS;
    private final int MAX_NUM_BUILDERS;
    private final int CALC_DELAY;
    private final LinkedBlockingQueue<BigInteger[]> _values;
    private final Thread _precalcThread;
    private final I2PAppContext ctx;
    private volatile boolean _isRunning;
    public static final String PROP_YK_PRECALC_MIN = "crypto.yk.precalc.min";
    public static final String PROP_YK_PRECALC_MAX = "crypto.yk.precalc.max";
    public static final String PROP_YK_PRECALC_DELAY = "crypto.yk.precalc.delay";
    public static final int DEFAULT_YK_PRECALC_MIN = 20;
    public static final int DEFAULT_YK_PRECALC_MAX = 50;
    public static final int DEFAULT_YK_PRECALC_DELAY = 200;
    private static final BigInteger _two = new NativeBigInteger(1, new byte[]{2});

    public YKGenerator(I2PAppContext context) {
        this.ctx = context;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x7F00000L;
        }
        int factor = (int)Math.max(1L, Math.min(8L, 1L + maxMemory / 0x8000000L));
        int defaultMin = 20 * factor;
        int defaultMax = 50 * factor;
        this.MIN_NUM_BUILDERS = this.ctx.getProperty(PROP_YK_PRECALC_MIN, defaultMin);
        this.MAX_NUM_BUILDERS = this.ctx.getProperty(PROP_YK_PRECALC_MAX, defaultMax);
        this.CALC_DELAY = this.ctx.getProperty(PROP_YK_PRECALC_DELAY, 200);
        this._values = new LinkedBlockingQueue(this.MAX_NUM_BUILDERS);
        this.ctx.statManager().createRateStat("crypto.YKUsed", "Need a YK from the queue", "Encryption", new long[]{3600000L});
        this.ctx.statManager().createRateStat("crypto.YKEmpty", "YK queue empty", "Encryption", new long[]{3600000L});
        this._precalcThread = new I2PThread(new YKPrecalcRunner(this.MIN_NUM_BUILDERS, this.MAX_NUM_BUILDERS), "YK Precalc", true);
        this._precalcThread.setPriority(1);
        this._isRunning = true;
        this._precalcThread.start();
    }

    public void shutdown() {
        this._isRunning = false;
        this._precalcThread.interrupt();
        this._values.clear();
    }

    private final int getSize() {
        return this._values.size();
    }

    private final boolean addValues(BigInteger[] yk) {
        return this._values.offer(yk);
    }

    public BigInteger[] getNextYK() {
        this.ctx.statManager().addRateData("crypto.YKUsed", 1L, 0L);
        BigInteger[] rv = this._values.poll();
        if (rv != null) {
            return rv;
        }
        this.ctx.statManager().addRateData("crypto.YKEmpty", 1L, 0L);
        return this.generateYK();
    }

    private final BigInteger[] generateYK() {
        NativeBigInteger k = null;
        BigInteger y = null;
        while (k == null) {
            k = new NativeBigInteger(226, this.ctx.random());
            if (BigInteger.ZERO.compareTo(k) == 0) {
                k = null;
                continue;
            }
            BigInteger kPlus2 = k.add(_two);
            if (kPlus2.compareTo(CryptoConstants.elgp) <= 0) continue;
            k = null;
        }
        y = CryptoConstants.elgg.modPow(k, CryptoConstants.elgp);
        BigInteger[] yk = new BigInteger[]{y, k};
        return yk;
    }

    private class YKPrecalcRunner
    implements Runnable {
        private final int _minSize;
        private final int _maxSize;
        private long _checkDelay = 30000L;

        private YKPrecalcRunner(int minSize, int maxSize) {
            this._minSize = minSize;
            this._maxSize = maxSize;
        }

        public void run() {
            while (YKGenerator.this._isRunning) {
                int startSize = YKGenerator.this.getSize();
                if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                    this._checkDelay -= 1000L;
                } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                    this._checkDelay += 1000L;
                }
                if (startSize < this._minSize) {
                    while (YKGenerator.this.getSize() < this._maxSize && YKGenerator.this._isRunning && YKGenerator.this.addValues(YKGenerator.this.generateYK())) {
                        try {
                            Thread.sleep(YKGenerator.this.CALC_DELAY);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                if (!YKGenerator.this._isRunning) break;
                try {
                    Thread.sleep(this._checkDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

