/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.IRandomStandalone;
import java.util.Map;

public abstract class BasePRNGStandalone
implements IRandomStandalone {
    protected String name;
    protected boolean initialised;
    protected byte[] buffer;
    protected int ndx;

    protected BasePRNGStandalone(String name) {
        this.name = name;
        this.initialised = false;
        this.buffer = new byte[0];
    }

    public String name() {
        return this.name;
    }

    public void init(Map attributes) {
        this.setup(attributes);
        this.ndx = 0;
        this.initialised = true;
    }

    public byte nextByte() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return this.nextByteInternal();
    }

    public void nextBytes(byte[] out) throws IllegalStateException {
        this.nextBytes(out, 0, out.length);
    }

    public void nextBytes(byte[] out, int offset, int length) throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("not initialized");
        }
        if (length == 0) {
            return;
        }
        if (offset < 0 || length < 0 || offset + length > out.length) {
            throw new ArrayIndexOutOfBoundsException("offset=" + offset + " length=" + length + " limit=" + out.length);
        }
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        int count = 0;
        while (count < length) {
            int amount = Math.min(this.buffer.length - this.ndx, length - count);
            System.arraycopy(this.buffer, this.ndx, out, offset + count, amount);
            count += amount;
            this.ndx += amount;
            if (this.ndx < this.buffer.length) continue;
            this.fillBlock();
            this.ndx = 0;
        }
    }

    public void addRandomByte(byte b) {
        throw new UnsupportedOperationException("random state is non-modifiable");
    }

    public void addRandomBytes(byte[] buffer) {
        this.addRandomBytes(buffer, 0, buffer.length);
    }

    public void addRandomBytes(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException("random state is non-modifiable");
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    private byte nextByteInternal() {
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        return this.buffer[this.ndx++];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract void setup(Map var1);

    public abstract void fillBlock();
}

